import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 12))
ax.set_xlim(0, 10)
ax.set_ylim(0, 6)
ax.set_aspect('equal')
ax.axis('off')

# Define colors
floor_color = 'lightgrey'
passenger_color = 'lightblue'
fast_elevator_color = 'lightgreen'
slow_elevator_color = 'lightgreen'
full_elevator_color = 'lightcoral'

# Define floor positions
floor_positions = [0, 1, 2, 3, 4, 5]

# Draw floors
for i, pos in enumerate(floor_positions):
    ax.add_patch(patches.Rectangle((0, pos), 10, 1, edgecolor='black', facecolor=floor_color))
    ax.text(0.5, pos + 0.5, f'Floor {i}', va='center', ha='center', fontsize=10, weight='bold')

# Draw passengers
passengers = {
    'p1': (0.5, 1),
    'p6': (1.0, 2),
    'p2': (0.5, 3),
    'p0': (0.5, 4),
    'p3': (1.0, 4),
    'p5': (0.5, 5),
}

for p, (x, y) in passengers.items():
    ax.add_patch(patches.Rectangle((x, y), 0.4, 0.4, edgecolor='black', facecolor=passenger_color))
    ax.text(x + 0.2, y + 0.2, p, va='center', ha='center', fontsize=8)

# Draw elevators
elevators = {
    'fast0': (8, 4, fast_elevator_color, '0/2'),
    'fast1': (8, 3, fast_elevator_color, '0/2'),
    'slow0-0': (7, 2, full_elevator_color, '1/1'),
}

for e, (x, y, color, status) in elevators.items():
    ax.add_patch(patches.Rectangle((x, y), 0.8, 0.4, edgecolor='black', facecolor=color))
    ax.text(x + 0.4, y + 0.2, f'{e}\n{status}', va='center', ha='center', fontsize=8)

# Draw passenger p4 inside slow0-0
ax.add_patch(patches.Rectangle((7.2, 2), 0.4, 0.4, edgecolor='black', facecolor=passenger_color))
ax.text(7.4, 2.2, 'p4', va='center', ha='center', fontsize=8)

# Create a legend
legend_elements = [
    patches.Patch(facecolor=passenger_color, edgecolor='black', label='Passenger'),
    patches.Patch(facecolor=fast_elevator_color, edgecolor='black', label='Fast Elevator (Available)'),
    patches.Patch(facecolor=slow_elevator_color, edgecolor='black', label='Slow Elevator (Available)'),
    patches.Patch(facecolor=full_elevator_color, edgecolor='black', label='Elevator (Full)')
]

ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()